'''
Tool for generating a list of albums from iTunes Library
- Author: Mathias Beke - http://denbeke.be
- Created: 7-3-2013
'''

from ParseItunes import *


class Album:
    '''Class representing an album with a name, artist, year'''
    
    def __init__(self, input_album, input_artist, input_year):
        '''Creates new album with given name, artist and year'''
        self.album = input_album
        self.artist = input_artist
        self.year = input_year
    
    def getAlbum(self):
        '''Returns the album'''
        return self.album
    
    def getArtist(self):
        '''Returns the artist'''
        return self.artist
    
    def getYear(self):
        '''Returns the year'''
        return self.year
        
    def __str__(self):
        '''Returns string of Album'''
        return str(self.album)+" - "+str(self.artist)+" - "+str(self.year)


class AlbumListGenerator:
    
    def __init__(self, input_file):
        '''Constructor'''
        self.parsedLibrary = iTunesParser(input_file)
        self.albums = list()
        
    def generateList(self):
        '''Generate list of albums'''
        
        self.parsedLibrary.parse()
        
        #Loop through tracks in parsed libary
        for track in self.parsedLibrary.getTrackList():
            
            #Add album to list if it is not yet found in the list
            if not self.isInList(track.getAlbum()):
                self.albums.append(Album(track.getAlbum(), track.getAlbumArtist(), track.getYear()))
            
    
    
    def getList(self):
        '''Return list of albums'''
        return self.albums
    
            
    def isInList(self, album_name):
        '''Check if the album with the given name is yet in the list'''
        #Loop through albums
        for album in self.albums:
            
            #Check if album name is found
            if album.getAlbum() == album_name:
                return True
        
        return False
    
    
    
    def sortList(self):
        '''Sort the list with the album name as search key'''
        self.albums.sort(key = lambda Album: Album.artist)

    
    def __str__(self):
        '''Returns string of List with all albums'''
        
        string = ""
        
        for i in range ( len(self.albums) ):
            
            string += str(i+1)+". "
            
            string += str(self.albums[i])
            
            if i != len(self.albums) - 1:
                string += "\n"
        
        return string